IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_RELATORIO_MOVIMENTO_VENDAS]'))
DROP VIEW [dbo].[V_RELATORIO_MOVIMENTO_VENDAS]
GO 

CREATE VIEW [dbo].[V_RELATORIO_MOVIMENTO_VENDAS] AS
SELECT 
	EST_MOVIMENTO_VENDAS.TIPO_VENDA AS TipoMovimento, 
	V_BI_MOVIMENTO_TIPO.DsTipoMovimento,
	EST_MOVIMENTO_VENDAS.CD_FILIAL AS Filial,
	GLB_DT_MOVIMENTO.DT_MOVIMENTO as DtMovimento,
     GLB_DT_MOVIMENTO.MES_MOVIMENTO as MesMovimento ,
     GLB_DT_MOVIMENTO.ANO_MOVIMENTO as AnoMovimento,
     GLB_DT_MOVIMENTO.ANO_MES_MOVIMENTO as AnoMesMovimento,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_PMC) AS VlrPMC, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_OFERTA) AS VlrOferta, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD) AS VlrVendaBruta, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_ITENS) AS VlrDescItens, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_VERBA) AS VlrDescVerba, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_RATEIO) AS VlrDescRateio,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ) AS VlrVdLiquida, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_MD) AS VlrCustoMedio, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO) AS VlrCustoUltimo, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_GER) AS VlrCustoGer, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_ICMS) AS VlrIcms, 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_PIS_COFINS) AS VlrPisCofins,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.QTDE_ITENS) AS QtdeItens,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DINHEIRO) AS VlrDinheiro,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CHEQUES) AS VlrCheques,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CHEQUES_VISTA) AS VlrChequesVista,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CHEQUES_PRAZO) AS VlrChequesPrazo,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CARTAO) AS VlrCartao,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_TICKETS) AS VlrTickets,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DUPLICATA) AS VlrDuplicata,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CONV) AS VlrConvenio,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CONV_PBM) AS VlrConvenioPbm,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CHEQUE_TROCO) AS VlrChequeTroco,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_NCC) AS VlrNcc,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.QTDE_VD) AS QtdeVdProduto,
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_COMISSAO) AS VlrComissao,
	ISNULL(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_COMISSAO_FABRIC),0) AS VlrComissaoFabric,
	ISNULL(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_RECOMPOSICAO_MARGEM),0) AS VlrRecomposicaoMargem,
	V_PDV_VD_ORIGEM_VENDA.DS_CD_ORIGEM_VENDA AS DsOrigemVenda
FROM            
	EST_MOVIMENTO_VENDAS_PRODUTOS INNER JOIN EST_MOVIMENTO_VENDAS ON
	EST_MOVIMENTO_VENDAS_PRODUTOS.CD_CTR_VENDAS = EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
	INNER JOIN GLB_DT_MOVIMENTO ON
	EST_MOVIMENTO_VENDAS.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
	INNER JOIN V_BI_MOVIMENTO_TIPO ON
	EST_MOVIMENTO_VENDAS.TIPO_VENDA = V_BI_MOVIMENTO_TIPO.TipoMovimento
	INNER JOIN V_PDV_VD_ORIGEM_VENDA ON
	EST_MOVIMENTO_VENDAS_PRODUTOS.CD_ORIGEM_VENDA = V_PDV_VD_ORIGEM_VENDA.CD_ORIGEM_VENDA	
WHERE
	EST_MOVIMENTO_VENDAS.TIPO_VENDA IN (0,2,3,10,11)
GROUP BY
	EST_MOVIMENTO_VENDAS.CD_FILIAL,
	EST_MOVIMENTO_VENDAS.TIPO_VENDA, 
	V_BI_MOVIMENTO_TIPO.DsTipoMovimento,
	GLB_DT_MOVIMENTO.DT_MOVIMENTO,
	GLB_DT_MOVIMENTO.MES_MOVIMENTO,
     GLB_DT_MOVIMENTO.ANO_MOVIMENTO,
     GLB_DT_MOVIMENTO.ANO_MES_MOVIMENTO,
	V_PDV_VD_ORIGEM_VENDA.DS_CD_ORIGEM_VENDA